/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.guis.instances;

import java.util.ArrayList;
import java.util.List;
import minecrafttransportsimulator.baseclasses.ColorRGB;
import minecrafttransportsimulator.baseclasses.EntityManager;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.guis.components.AGUIBase;
import minecrafttransportsimulator.guis.components.GUIComponent3DModel;
import minecrafttransportsimulator.guis.components.GUIComponentButton;
import minecrafttransportsimulator.guis.components.GUIComponentLabel;
import minecrafttransportsimulator.guis.components.GUIComponentTextBox;
import minecrafttransportsimulator.jsondefs.JSONVehicle;
import minecrafttransportsimulator.packloading.JSONParser;

public class GUIPackExporter
extends AGUIBase {
    private GUIComponentButton modelRenderButton;
    private GUIComponentButton packExportButton;
    private GUIComponentButton packImportButton;
    private GUIComponentTextBox debug;
    private final EntityVehicleF_Physics vehicleClicked;
    private final List<GUIComponentTextBox> dataEntryBoxes = new ArrayList<GUIComponentTextBox>();
    private final List<GUIComponentLabel> dataEntryLabels = new ArrayList<GUIComponentLabel>();
    private GUIComponentButton backButton;
    private GUIComponentButton confirmButton;
    private GUIComponent3DModel componentItemModel;

    public GUIPackExporter(EntityVehicleF_Physics vehicleClicked) {
        this.vehicleClicked = vehicleClicked;
    }

    @Override
    public void setupComponents() {
        super.setupComponents();
        int buttonWidth = 116;
        int buttonOffset = -(350 - this.getWidth()) / 2;
        this.packExportButton = new GUIComponentButton(this, this.guiLeft + buttonOffset, this.guiTop, buttonWidth, 20, "EXPORT PACKS"){

            @Override
            public void onClicked(boolean leftSide) {
                GUIPackExporter.this.debug.setText(JSONParser.exportAllJSONs());
            }
        };
        this.addComponent(this.packExportButton);
        this.packImportButton = new GUIComponentButton(this, this.guiLeft + buttonWidth + buttonOffset, this.guiTop, buttonWidth, 20, "IMPORT PACKS"){

            @Override
            public void onClicked(boolean leftSide) {
                EntityManager.doImports(() -> GUIPackExporter.this.debug.setText(JSONParser.importAllJSONs(false)));
            }
        };
        this.addComponent(this.packImportButton);
        this.modelRenderButton = new GUIComponentButton(this, this.guiLeft + 2 * buttonWidth + buttonOffset, this.guiTop, buttonWidth, 20, "MODEL RENDER"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIPackExporter)GUIPackExporter.this).modelRenderButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).packExportButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).packImportButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).debug.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).componentItemModel.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).backButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).confirmButton.visible = true;
                for (GUIComponentTextBox dataEntryBox : GUIPackExporter.this.dataEntryBoxes) {
                    dataEntryBox.visible = true;
                }
            }
        };
        this.addComponent(this.modelRenderButton);
        this.backButton = new GUIComponentButton(this, this.guiLeft + 20, this.guiTop + 140, 60, 20, "BACK"){

            @Override
            public void onClicked(boolean leftSide) {
                ((GUIPackExporter)GUIPackExporter.this).modelRenderButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).packExportButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).packImportButton.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).debug.visible = true;
                ((GUIPackExporter)GUIPackExporter.this).componentItemModel.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).backButton.visible = false;
                ((GUIPackExporter)GUIPackExporter.this).confirmButton.visible = false;
                for (GUIComponentTextBox dataEntryBox : GUIPackExporter.this.dataEntryBoxes) {
                    dataEntryBox.visible = false;
                }
            }
        };
        this.addComponent(this.backButton);
        this.confirmButton = new GUIComponentButton(this, this.guiLeft + 100, this.guiTop + 140, 60, 20, "CONFIRM"){

            @Override
            public void onClicked(boolean leftSide) {
                try {
                    int dataEntryBoxIndex = 0;
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.modelLocation = String.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.textureLocation = String.valueOf(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.position.x = ((GUIPackExporter)GUIPackExporter.this).componentItemModel.constructedX + Integer.parseInt(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.position.y = -((GUIPackExporter)GUIPackExporter.this).componentItemModel.constructedY - Integer.parseInt(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                    ((GUIPackExporter)GUIPackExporter.this).componentItemModel.scale = Float.parseFloat(((GUIComponentTextBox)GUIPackExporter.this.dataEntryBoxes.get(dataEntryBoxIndex++)).getText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.addComponent(this.confirmButton);
        this.debug = new GUIComponentTextBox(this, this.guiLeft + buttonOffset, this.guiTop + 20, 350, this.getHeight() - 20, "", ColorRGB.WHITE, 1200);
        this.addComponent(this.debug);
        this.dataEntryBoxes.clear();
        this.dataEntryLabels.clear();
        int currentRow = 15;
        for (int i = 0; i < 5; i = (int)((byte)(i + 1))) {
            int height = i < 2 ? 40 : 10;
            GUIComponentTextBox dataEntryBox = new GUIComponentTextBox(this, this.guiLeft + 100, this.guiTop + currentRow, 140, height, "", ColorRGB.WHITE, 100);
            GUIComponentLabel dataEntryLabel = new GUIComponentLabel(this.guiLeft + 15, dataEntryBox.constructedY, ColorRGB.WHITE, "").setComponent(dataEntryBox);
            this.dataEntryBoxes.add(dataEntryBox);
            this.dataEntryLabels.add(dataEntryLabel);
            this.addComponent(dataEntryBox);
            this.addComponent(dataEntryLabel);
            currentRow += height + 1;
        }
        this.componentItemModel = new GUIComponent3DModel(this.guiLeft, this.guiTop, 1.0f, true, false, true);
        this.componentItemModel.position.add(208.0, -205.0, 0.0);
        this.componentItemModel.scale = 6.0f;
        this.addComponent(this.componentItemModel);
        int labelBoxIndex = 0;
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Model:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(((JSONVehicle)this.vehicleClicked.definition).getModelLocation(this.vehicleClicked.subDefinition));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Texture:";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(((JSONVehicle)this.vehicleClicked.definition).getTextureLocation(this.vehicleClicked.subDefinition));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "X-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf((int)this.componentItemModel.position.x - this.componentItemModel.constructedX));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Y-Pos (px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf((int)(-this.componentItemModel.position.y) + this.componentItemModel.constructedY));
        this.dataEntryLabels.get((int)labelBoxIndex).text = "Scale (1blk=1px):";
        this.dataEntryBoxes.get(labelBoxIndex++).setText(String.valueOf(this.componentItemModel.scale));
        this.backButton.onClicked(false);
    }

    @Override
    public void setStates() {
        super.setStates();
        try {
            this.componentItemModel.position.x = this.componentItemModel.constructedX + Integer.parseInt(this.dataEntryBoxes.get(2).getText());
            this.componentItemModel.position.y = this.componentItemModel.constructedY - Integer.parseInt(this.dataEntryBoxes.get(3).getText());
            this.componentItemModel.scale = Float.parseFloat(this.dataEntryBoxes.get(4).getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected boolean renderBackground() {
        return this.componentItemModel != null && this.componentItemModel.visible;
    }
}

